import '../../theme/colors.dart';
import 'package:flutter/material.dart';
import 'package:auto_size_text/auto_size_text.dart';

class LargeTitle extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const LargeTitle({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      alignment: Alignment.centerLeft,
      child: AutoSizeText(
        text,
        maxLines: 3,
        style: Theme.of(context)
            .textTheme
            .titleLarge!
            .copyWith(color: primaryColor),
      ),
    );
  }
}
