import '../../theme/device_type.dart';
import 'package:flutter/material.dart';
import 'package:auto_size_text/auto_size_text.dart';


class SimpleTitle extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const SimpleTitle({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      alignment: Alignment.centerLeft,
      child: AutoSizeText(
        text,
        style: Theme.of(context).textTheme.titleLarge,
        maxLines: 1,
      ),
    );
  }
}
