import 'package:flutter/material.dart';
import 'package:auto_size_text/auto_size_text.dart';

class SimpleSubTitle extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const SimpleSubTitle({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: double.infinity,
      alignment: Alignment.centerLeft,
      child: AutoSizeText(
        text,
        style: Theme.of(context)
            .textTheme
            .titleMedium!
            .copyWith(fontWeight: FontWeight.w600),
        maxLines: 1,
      ),
    );
  }
}
