import '../../theme/colors.dart';
import '../../theme/device_type.dart';
import 'package:flutter/material.dart';

class SimpleDescription extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const SimpleDescription({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      alignment: Alignment.centerLeft,
      child: Text(
        text,
        style: Theme.of(context)
            .textTheme
            .bodyMedium!
            .copyWith(color: textColorLight, fontWeight: FontWeight.w400),
      ),
    );
  }
}
