import 'package:flutter/material.dart';

class BNavigator {
  rightNavigate(context, widget) {
    Navigator.pushAndRemoveUntil(
        context,
        SlideRightRoute(
          page: widget,
        ),
        (Route<dynamic> route) => false);
  }

  historyRightNavigate(context, widget) {
    Navigator.push(
      context,
      SlideRightRoute(
        page: widget,
      ),
    );
  }

  leftNavigate(context, widget) {
    Navigator.pushAndRemoveUntil(
        context,
        SlideLeftRoute(
          page: widget,
        ),
        (Route<dynamic> route) => false);
  }

  historyLeftNavigate(context, widget) {
    Navigator.push(
      context,
      SlideLeftRoute(
        page: widget,
      ),
    );
  }

  fadeNavigate(context, widget) {
    Navigator.pushAndRemoveUntil(
        context,
        FadeRoute(
          page: widget,
        ),
        (Route<dynamic> route) => false);
  }

  heroNavigate(context, widget) {
    Navigator.pushReplacement(
      context,
      PageRouteBuilder(
        pageBuilder: (context, animation1, animation2) => widget,
        transitionDuration: const Duration(milliseconds: 1700),
      ),
    );
  }

  historyFadeNavigate(context, widget) {
    Navigator.push(
        context,
        FadeRoute(
          page: widget,
        ));
  }
}

class SlideRightRoute extends PageRouteBuilder {
  final Widget page;
  SlideRightRoute({required this.page})
      : super(
          pageBuilder: (
            BuildContext context,
            Animation<double> animation,
            Animation<double> secondaryAnimation,
          ) =>
              page,
          transitionDuration: const Duration(milliseconds: 200),
          transitionsBuilder: (
            BuildContext context,
            Animation<double> animation,
            Animation<double> secondaryAnimation,
            Widget child,
          ) =>
              SlideTransition(
            position: Tween<Offset>(
              begin: const Offset(1, 0),
              end: Offset.zero,
            ).animate(animation),
            child: child,
          ),
        );
}

class SlideLeftRoute extends PageRouteBuilder {
  final Widget page;
  SlideLeftRoute({required this.page})
      : super(
          pageBuilder: (
            BuildContext context,
            Animation<double> animation,
            Animation<double> secondaryAnimation,
          ) =>
              page,
          transitionDuration: const Duration(milliseconds: 200),
          transitionsBuilder: (
            BuildContext context,
            Animation<double> animation,
            Animation<double> secondaryAnimation,
            Widget child,
          ) =>
              SlideTransition(
            position: Tween<Offset>(
              begin: const Offset(-1, 0),
              end: Offset.zero,
            ).animate(animation),
            child: child,
          ),
        );
}

class FadeRoute extends PageRouteBuilder {
  final Widget page;
  FadeRoute({required this.page})
      : super(
          pageBuilder: (
            BuildContext context,
            Animation<double> animation,
            Animation<double> secondaryAnimation,
          ) =>
              page,
          transitionDuration: const Duration(milliseconds: 500),
          transitionsBuilder: (
            BuildContext context,
            Animation<double> animation,
            Animation<double> secondaryAnimation,
            Widget child,
          ) =>
              FadeTransition(
            opacity: Tween<double>(
              begin: 0,
              end: 1,
            ).animate(animation),
            child: child,
          ),
        );
}
