import '../../theme/colors.dart';
import 'package:flutter/material.dart';

class LoadingIndicator extends StatelessWidget {
  const LoadingIndicator({super.key});

  @override
  Widget build(BuildContext context) {
    return Container(
      width: 48.0,
      height: 48.0,
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(12.0),
          color: secondaryColor.withOpacity(0.6)),
      alignment: Alignment.center,
      child: const SizedBox(
        width: 24.0,
        height: 24.0,
        child: CircularProgressIndicator(
          color: primaryColor,
        ),
      ),
    );
  }
}
