class TValidators {
  /// Validates name
  String? validateName(String? text) {
    String value = text!.replaceAll(" ", "");
    RegExp nameReg = RegExp(r"^[a-zA-Z.-_ ]+$");
    var matches = nameReg.hasMatch(value);
    if (value.isEmpty) {
      return "Name is Required";
    }
    if (value.length < 3) {
      return "Name should be at least 3 Characters long";
    } else if (value.length > 40) {
      return "Name should be less than 40 Characters";
    } else if (!matches) {
      return "Invalid name";
    } else {
      return null;
    }
  }

  /// Validate Empty
  String? validateEmpty(String? text) {
    String value = text!.replaceAll(" ", "");
    if (value.isEmpty) {
      return "Name is Required";
    }
    if (value.length < 3) {
      return "Name should be at least 3 Characters long";
    } else if (value.length > 40) {
      return "Name should be less than 40 Characters";
    } else {
      return null;
    }
  }

  /// Validates short name
  String? validateUsername(String? value) {
    RegExp nameReg = RegExp(r'^[a-zA-Z0-9]+$');
    var matches = nameReg.hasMatch(value!);
    if (value.length < 3) {
      return "Should be at least 3 Characters long";
    } else if (!matches) {
      return "Should contain only alphabets and numbers";
    } else {
      return null;
    }
  }

  /// Validates double
  String? validateDouble(String? value) {
    RegExp nameReg = RegExp(r"[0-9.]");
    var matches = nameReg.hasMatch(value!.trim());
    if (!matches) {
      return "Enter a valid Number";
    } else {
      try {
        double val = double.parse(value.trim());
        if (val >= 0.0) {
          return null;
        } else {
          return "Invalid";
        }
      } catch (e) {
        return "Enter a valid Number";
      }
    }
  }

  /// Validates integer
  String? validateInteger(String? value) {
    RegExp nameReg = RegExp(r"[0-9]");
    var matches = nameReg.hasMatch(value!);
    if (!matches) {
      return "Enter a valid Number";
    } else {
      try {
        int.parse(value);
        return null;
      } catch (e) {
        return "Enter a valid Number";
      }
    }
  }

  /// Validates email
  String? validateEmail(String? value) {
    RegExp nameReg = RegExp(
        r"^[a-zA-Z0-9.!#$%&’*+/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$");
    var matches = nameReg.hasMatch(value!);

    if (value.isEmpty) {
      return "Email is Required";
    } else if (value.length > 50) {
      return "Email should be less than 50 Characters";
    } else if (!matches) {
      return "Not a valid Email";
    } else {
      List invalidExt = ['con', 'comm', 'cim', 'cin', 'c'];
      List invalidDomains = [
        'gmali',
        'gnail',
        'gma',
        'gmal',
        'gmali',
        'gamil',
        'gamail',
        'gma0il',
        'gmaail',
        'gnsil',
        'gmall',
        'gmall',
        'gemail.comm',
        'gemel',
        'gmsil',
        'gmai',
        'gmil',
        'gmao',
        'gnilu',
        'hotmai',
        'hotmal',
        'hotmali',
        'hotnail',
        'hitmail',
        'hormail',
        'xxxx.com',
        'xxx.com',
        'yhoo.com',
        'example.com',
        'test.com'
      ];
      if (value.contains(',')) {
        return "Invalid Email";
      } else {
        var ext = value.split(".").last;
        if (invalidExt.contains(ext)) {
          return "Invalid Email";
        }
        var domain = value.split("@").last.split(".").first;
        if (invalidDomains.contains(domain)) {
          return "Invalid Email";
        }
        return null;
      }
    }
  }

  /// Validates password
  String? validatePassword(String? value) {
    if (value == null) {
      return "Password is Required";
    } else if (value.isEmpty) {
      return "Password is Required";
    } else if (value.length <= 5 || value.length > 20) {
      return "Password should be 5 to 20 characters long";
    } else {
      return null;
    }
  }

  /// Validates password
  String? validateDate(String? value) {
    if (value == null) {
      return "Date is required";
    } else if (value.isEmpty) {
      return "Date is required";
    } else if (value.length <= 5) {
      return "Date is required";
    } else {
      return null;
    }
  }
}
