import '../../../theme/device_type.dart';
import '../validators.dart';
import 'package:flutter/material.dart';

class NameInput extends StatelessWidget {
  /// Variables
  final String hint;
  final bool autoValidate;
  final Function changeFunc;
  final TextEditingController controller;

  /// Initialize
  const NameInput(
      {super.key,
      required this.hint,
      required this.autoValidate,
      required this.controller,
      required this.changeFunc});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 72.0,
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      child: TextFormField(
        controller: controller,
        autovalidateMode:
            autoValidate ? AutovalidateMode.always : AutovalidateMode.disabled,
        validator: TValidators().validateName,
        maxLines: 1,
        onChanged: (val) {
          changeFunc();
        },
        keyboardType: TextInputType.text,
        decoration: InputDecoration(
          hintText: hint,
        ),
      ),
    );
  }
}
