import 'package:flutter/material.dart';
import '../../theme/device_type.dart';

class InputLabel extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const InputLabel({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SizedBox(
        width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
        height: Device.screenWidth > 600.0 ? 36.0 : 26.0,
        child: Text(
          text,
          textAlign: TextAlign.start,
          style: Theme.of(context).textTheme.bodyLarge?.copyWith(
                fontWeight: FontWeight.w600,
              ),
        ));
  }
}
