import '../../../theme/device_type.dart';
import '../validators.dart';
import 'package:flutter/material.dart';

class PasswordInput extends StatelessWidget {
  /// Variables
  final bool obscure;
  final Function showHide;
  final bool autoValidate;
  final TextEditingController passwordController;

  /// Initialize
  const PasswordInput(
      {super.key,
      required this.showHide,
      required this.obscure,
      required this.autoValidate,
      required this.passwordController});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 72.0,
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      child: TextFormField(
        controller: passwordController,
        autovalidateMode:
            autoValidate ? AutovalidateMode.always : AutovalidateMode.disabled,
        validator: TValidators().validatePassword,
        maxLines: 1,
        obscureText: obscure,
        keyboardType: TextInputType.emailAddress,
        decoration: InputDecoration(
            hintText: "Enter your password",
            suffixIcon: IconButton(
                onPressed: () {
                  showHide();
                },
                icon: Icon(obscure ? Icons.remove_red_eye : Icons.lock))),
      ),
    );
  }
}
