import '../../../theme/device_type.dart';
import '../validators.dart';
import 'package:flutter/material.dart';

class EmailInput extends StatelessWidget {
  /// Variables
  final bool autoValidate;
  final TextEditingController emailController;

  /// Initialize
  const EmailInput(
      {super.key, required this.autoValidate, required this.emailController});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 72.0,
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      child: TextFormField(
        controller: emailController,
        autovalidateMode:
            autoValidate ? AutovalidateMode.always : AutovalidateMode.disabled,
        validator: TValidators().validateEmail,
        maxLines: 1,
        keyboardType: TextInputType.emailAddress,
        decoration: const InputDecoration(
          hintText: "Enter your Email Address",
        ),
      ),
    );
  }
}
