import '../../../theme/device_type.dart';
import '../validators.dart';
import 'package:flutter/material.dart';

class ConfirmPasswordInput extends StatelessWidget {
  /// Variables
  final bool autoValidate;
  final TextEditingController confirmPasswordController;

  /// Initialize
  const ConfirmPasswordInput(
      {super.key,
      required this.autoValidate,
      required this.confirmPasswordController});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      height: 72.0,
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      child: TextFormField(
        controller: confirmPasswordController,
        autovalidateMode:
            autoValidate ? AutovalidateMode.always : AutovalidateMode.disabled,
        validator: TValidators().validatePassword,
        maxLines: 1,
        obscureText: false,
        keyboardType: TextInputType.emailAddress,
        decoration: const InputDecoration(hintText: "Confirm password"),
      ),
    );
  }
}
