import '../../theme/colors.dart';
import 'package:flutter/material.dart';

class EmptyWithIcon extends StatelessWidget {
  /// Variables
  final String title;
  final Color iconColor;
  final IconData iconData;
  final String description;

  /// Initialize
  const EmptyWithIcon(
      {super.key,
      required this.title,
      required this.iconColor,
      required this.iconData,
      required this.description});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
        padding: const EdgeInsets.only(left: 20.0, right: 20.0, bottom: 50.0),
        alignment: Alignment.center,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            /// Image
            Container(
              width: double.infinity,
              height: 200.0,
              alignment: Alignment.center,
              child: Icon(
                iconData,
                size: 120,
                color: iconColor,
              ),
            ),

            /// Spacing
            const SizedBox(
              height: 10.0,
            ),

            /// Title
            Text(
              title,
              textAlign: TextAlign.center,
              style: Theme.of(context)
                  .textTheme
                  .titleMedium!
                  .copyWith(fontWeight: FontWeight.w800),
            ),

            /// Spacing
            const SizedBox(
              height: 20.0,
            ),

            /// Title
            SizedBox(
              width: 300.0,
              child: Text(
                description,
                textAlign: TextAlign.center,
                style: Theme.of(context)
                    .textTheme
                    .bodyMedium!
                    .copyWith(color: textColorDark.withOpacity(0.5)),
              ),
            ),

            /// Spacing
            const SizedBox(
              height: 20.0,
            ),
          ],
        ));
  }
}
