import '../../theme/colors.dart';
import 'package:flutter/material.dart';

class EmptyWithButton extends StatelessWidget {
  /// Variables
  final String image;
  final String title;
  final String description;
  final String buttonText;
  final Function actionFunc;

  /// Initialize
  const EmptyWithButton(
      {super.key,
        required this.image,
        required this.title,
        required this.actionFunc,
        required this.buttonText,
        required this.description});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
        padding: const EdgeInsets.only(left: 20.0, right: 20.0, bottom: 20.0),
        alignment: Alignment.center,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            /// Image
            Container(
              width: double.infinity,
              height: 300.0,
              alignment: Alignment.center,
              child: Image.asset(
                image,
                fit: BoxFit.contain,
              ),
            ),

            /// Spacing
            const SizedBox(
              height: 10.0,
            ),

            /// Title
            Text(
              title,
              textAlign: TextAlign.center,
              style: Theme.of(context)
                  .textTheme
                  .titleMedium!
                  .copyWith(fontWeight: FontWeight.w800),
            ),

            /// Spacing
            const SizedBox(
              height: 20.0,
            ),

            /// Title
            Text(
              description,
              textAlign: TextAlign.center,
              style: Theme.of(context)
                  .textTheme
                  .bodyMedium!
                  .copyWith(color: textColorDark.withOpacity(0.5)),
            ),

            /// Spacing
            const SizedBox(
              height: 20.0,
            ),

            /// Button
            TextButton(
                onPressed: () {
                  actionFunc();
                },
                child: Container(
                    padding: const EdgeInsets.only(right: 10),
                    child: Text(buttonText)))
          ],
        ));
  }
}
