import '../../theme/colors.dart';
import 'package:flutter/material.dart';

class Empty extends StatelessWidget {
  /// Variables
  final String image;
  final String title;
  final String description;

  /// Initialize
  const Empty(
      {super.key,
      required this.image,
      required this.title,
      required this.description});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
        padding: const EdgeInsets.only(left: 20.0, right: 20.0, bottom: 20.0),
        alignment: Alignment.center,
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            /// Image
            Container(
              width: double.infinity,
              height: 200.0,
              alignment: Alignment.center,
              child: Image.asset(
                image,
                fit: BoxFit.contain,
              ),
            ),

            /// Spacing
            const SizedBox(
              height: 10.0,
            ),

            /// Title
            Text(
              title,
              textAlign: TextAlign.center,
              style: Theme.of(context)
                  .textTheme
                  .titleMedium!
                  .copyWith(fontWeight: FontWeight.w800),
            ),

            /// Spacing
            const SizedBox(
              height: 20.0,
            ),

            /// Title
            Text(
              description,
              textAlign: TextAlign.center,
              style: Theme.of(context)
                  .textTheme
                  .bodyMedium!
                  .copyWith(color: textColorDark.withOpacity(0.5)),
            ),

            /// Spacing
            const SizedBox(
              height: 20.0,
            ),
          ],
        ));
  }
}
