import '../../theme/colors.dart';
import 'package:flutter/material.dart';

class SmallButton extends StatelessWidget {
  /// Variables
  final String text;
  final Color color;
  final Color textColor;
  final bool isProcessing;
  final Function actionFunc;

  /// Initialize
  const SmallButton(
      {super.key,
      required this.text,
      required this.color,
      required this.textColor,
      required this.isProcessing,
      required this.actionFunc});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: 120,
      height: 35.0,
      alignment: Alignment.center,
      child: isProcessing
          ? const Center(
              child: SizedBox(
                width: 24.0,
                height: 24.0,
                child: CircularProgressIndicator(
                  color: secondaryColor,
                ),
              ),
            )
          : Row(
              children: [
                Expanded(
                  child: OutlinedButton(
                    style: OutlinedButton.styleFrom(
                        padding: const EdgeInsets.all(0),
                        side: const BorderSide(color: textColorLight)),
                    child: Text(
                      text,
                      style: Theme.of(context).textTheme.bodyMedium!.copyWith(
                            fontWeight: FontWeight.w600,
                          ),
                    ),
                    onPressed: () {
                      actionFunc();
                    },
                  ),
                ),
              ],
            ),
    );
  }
}
