import '../../theme/colors.dart';
import '../../theme/device_type.dart';
import 'package:flutter/material.dart';

class SmallButton extends StatelessWidget {
  /// Variables
  final String text;
  final Color color;
  final Color textColor;
  final bool isProcessing;
  final Function actionFunc;

  /// Initialize
  const SmallButton(
      {super.key,
      required this.text,
      required this.color,
      required this.textColor,
      required this.isProcessing,
      required this.actionFunc});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      height: 60.0,
      alignment: Alignment.topCenter,
      child: isProcessing
          ? const Center(
              child: SizedBox(
                width: 24.0,
                height: 24.0,
                child: CircularProgressIndicator(
                  color: secondaryColor,
                ),
              ),
            )
          : Row(
              children: [
                Expanded(
                  child: ElevatedButton(
                    style: ElevatedButton.styleFrom(
                        backgroundColor: color,
                        minimumSize: const Size(120, 48)),
                    child: Text(
                      text,
                      style: TextStyle(color: textColor),
                    ),
                    onPressed: () {
                      actionFunc();
                    },
                  ),
                ),
              ],
            ),
    );
  }
}
