import '../../theme/colors.dart';
import '../../theme/device_type.dart';
import 'package:flutter/material.dart';

class SimpleButton extends StatelessWidget {
  /// Variables
  final String text;
  final Color color;
  final Color textColor;
  final bool isProcessing;
  final Function actionFunc;

  /// Initialize
  const SimpleButton(
      {super.key,
      required this.text,
      required this.color,
      required this.textColor,
      required this.isProcessing,
      required this.actionFunc});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      width: Device.screenWidth > 600.0 ? 400.0 : double.infinity,
      height: 60.0,
      alignment: Alignment.center,
      child: isProcessing
          ? const Center(
              child: SizedBox(
                width: 24.0,
                height: 24.0,
                child: CircularProgressIndicator(
                  color: secondaryColor,
                ),
              ),
            )
          : Row(
              children: [
                Expanded(
                  child: ElevatedButton(
                    style: ElevatedButton.styleFrom(backgroundColor: color),
                    child: Text(
                      text,
                      style: TextStyle(color: textColor),
                    ),
                    onPressed: () {
                      actionFunc();
                    },
                  ),
                ),
              ],
            ),
    );
  }
}
