import 'dart:async';
import '../../theme/colors.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:webview_flutter/webview_flutter.dart';

class LinkBrowser extends StatefulWidget {
  final String url;
  final String text;
  const LinkBrowser({super.key, required this.url, required this.text});

  @override
  LinkBrowserState createState() => LinkBrowserState();
}

class LinkBrowserState extends State<LinkBrowser> {
  /// Variables
  bool isLoading = true;
  bool _initialized = false;
  bool isLaunchingExternalUrl = false;
  late WebViewController _controller;

  /// Init
  @override
  void initState() {
    _load();
    super.initState();
  }

  /// Dispose
  @override
  void dispose() {
    super.dispose();
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: primaryColor,
      appBar: AppBar(
        elevation: 0.0,
        leading: const CloseButton(),
        title: Text(widget.text),
        systemOverlayStyle:
            const SystemUiOverlayStyle(statusBarBrightness: Brightness.dark),
      ),
      body: Stack(
        children: [
          /// Web-view
          _initialized ? WebViewWidget(controller: _controller) : Container(),

          /// Loading
          isLoading
              ? Container(
                  alignment: Alignment.center,
                  color: textColorDark.withOpacity(0.2),
                  child: const SizedBox(
                    width: 24.0,
                    height: 24.0,
                    child: CircularProgressIndicator(
                      color: secondaryColor,
                    ),
                  ),
                )
              : Container()
        ],
      ),
    );
  }

  /// Load
  _load() async {
    _controller = WebViewController()
      ..setJavaScriptMode(JavaScriptMode.unrestricted)
      ..setBackgroundColor(const Color(0x00000000))
      ..setNavigationDelegate(
        NavigationDelegate(
          onProgress: (int progress) {
            isLoading = true;
            _changeState();
          },
          onPageStarted: (String url) {},
          onPageFinished: (String url) {
            isLoading = false;
            _changeState();
          },
          onWebResourceError: (WebResourceError error) {
            isLoading = false;
            _changeState();
          },
          onNavigationRequest: (NavigationRequest request) {
            return NavigationDecision.navigate;
          },
        ),
      )
      ..loadRequest(Uri.parse(widget.url));
    _initialized = true;
    await Future.delayed(const Duration(seconds: 2));
    isLoading = false;
    _changeState();
  }

  /// Change state
  _changeState() {
    if (mounted) {
      setState(() {});
    }
  }
}
