import '../../theme/colors.dart';
import 'package:flutter/material.dart';
import 'package:cached_network_image/cached_network_image.dart';

class SimpleUserAvatar extends StatefulWidget {
  /// Variables
  final String image;
  final double size;

  /// Initialize
  const SimpleUserAvatar({
    super.key,
    required this.image,
    required this.size,
  });

  @override
  State<SimpleUserAvatar> createState() => _SimpleUserAvatarState();
}

class _SimpleUserAvatarState extends State<SimpleUserAvatar> {
  @override
  Widget build(BuildContext context) {
    return widget.image.isNotEmpty
        ? CircleAvatar(
      backgroundImage: CachedNetworkImageProvider(widget.image),
      minRadius: widget.size - 1.0,
      maxRadius: widget.size - 1.0,
    )
        : CircleAvatar(
      backgroundColor: secondaryColor,
      minRadius: widget.size - 1.0,
      maxRadius: widget.size - 1.0,
      child: Icon(
        Icons.person,
        size: 5 * widget.size / 4,
        color: primaryColor,
      ),
    );
  }
}
