import '../../theme/colors.dart';
import 'package:flutter/material.dart';

/// PSnackbars - stateless widget
class PSnackbars {
  /// Error snackbars
  void showErrorSnackbar(String value, BuildContext context) {
    if (value.isEmpty) {
      return;
    } else {
      ScaffoldMessenger.of(context).showSnackBar(SnackBar(
        content: Text(
          value,
          style:
              const TextStyle(color: Colors.white, fontWeight: FontWeight.w600),
          textAlign: TextAlign.center,
        ),
        backgroundColor: errorColor,
      ));
    }
  }

  /// Show snackbars
  void showSnackbar(String value, BuildContext context) {
    if (value.isEmpty) {
      return;
    } else {
      ScaffoldMessenger.of(context).showSnackBar(SnackBar(
        content: Text(
          value,
          style:
              const TextStyle(color: Colors.white, fontWeight: FontWeight.w600),
          textAlign: TextAlign.center,
        ),
        backgroundColor: secondaryColor,
      ));
    }
  }

  /// Show blue snackbars
  void showBlueSnackbar(String value, BuildContext context) {
    if (value.isEmpty) {
      return;
    } else {
      ScaffoldMessenger.of(context).showSnackBar(SnackBar(
        content: Text(
          value,
          style:
              const TextStyle(color: Colors.white, fontWeight: FontWeight.w600),
          textAlign: TextAlign.center,
        ),
        duration: const Duration(seconds: 3),
        backgroundColor: secondaryColor,
      ));
    }
  }
}
