import '../loading/loading.dart';
import 'package:flutter/material.dart';


class ProgressCard extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const ProgressCard({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SizedBox(
      width: double.infinity,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          /// Loading
          const LoadingIndicator(),

          /// Spacing
          const SizedBox(
            height: 24,
          ),

          /// Text
          Text(
            "$text..",
            style: Theme.of(context).textTheme.bodyLarge,
          )
        ],
      ),
    );
  }
}
