import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:adaptive_theme/adaptive_theme.dart';

class ThemeTest extends StatelessWidget {
  const ThemeTest({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("Testing Theme"),
        actions: [
          SizedBox(
            width: 20.0,
            child: IconButton(
                onPressed: () {
                  if (Theme.of(context).brightness == Brightness.dark) {
                    AdaptiveTheme.of(context).setLight();
                  } else {
                    AdaptiveTheme.of(context).setDark();
                  }
                },
                icon: Icon(Theme.of(context).brightness == Brightness.dark
                    ? Icons.sunny
                    : Icons.nightlight)),
          ),
          const SizedBox(
            width: 20.0,
          ),
        ],
      ),
      drawer: const Drawer(),
      body: SingleChildScrollView(
        child: Container(
          width: double.infinity,
          margin: const EdgeInsets.all(20.0),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              /// Elevated button
              ElevatedButton(
                  onPressed: () {
                    _showBottomSheet(context);
                  },
                  child: const Text("Show Bottom Sheet")),

              /// Spacing
              const SizedBox(
                height: 30.0,
              ),

              /// Outlined button
              OutlinedButton(
                  onPressed: () {
                    _showPopupDialog(context);
                  },
                  child: const Text("Show Pop up")),

              /// Spacing
              const SizedBox(
                height: 30.0,
              ),

              /// Text Field
              const TextField(
                decoration: InputDecoration(
                  hintText: "Hint Text",
                  suffixIcon: Icon(Icons.golf_course),
                ),
              ),

              /// Spacing
              const SizedBox(
                height: 30.0,
              ),

              /// Heading 1
              Text(
                "HOLESWING",
                style: Theme.of(context).textTheme.displayLarge?.copyWith(
                    fontStyle: FontStyle.italic, letterSpacing: -1.0),
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Heading 2
              Text(
                "Heading 2",
                style: Theme.of(context).textTheme.displayMedium,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Heading 3
              Text(
                "Heading 3",
                style: Theme.of(context).textTheme.displaySmall,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Heading 4
              Text(
                "Heading 4",
                style: Theme.of(context).textTheme.headlineMedium,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Heading 5
              Text(
                "Heading 5",
                style: Theme.of(context).textTheme.headlineSmall,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Heading 6
              Text(
                "Heading 6",
                style: Theme.of(context).textTheme.titleLarge,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Subtitle 1
              Text(
                "Subtitle 1",
                style: Theme.of(context).textTheme.titleMedium,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Subtitle 2
              Text(
                "Subtitle 2",
                style: Theme.of(context).textTheme.titleSmall,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Body text 1
              Text(
                "Bodytext 1",
                style: Theme.of(context).textTheme.bodyLarge,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Body text 2
              Text(
                "Bodytext 2",
                style: Theme.of(context).textTheme.bodyMedium,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Caption
              Text(
                "Caption",
                style: Theme.of(context).textTheme.bodySmall,
              ),

              /// Spacing
              const SizedBox(
                height: 10.0,
              ),

              /// Overline
              Text(
                "Overline",
                style: Theme.of(context).textTheme.labelSmall,
              ),
            ],
          ),
        ),
      ),
    );
  }

  /// Show pop up
  void _showPopupDialog(BuildContext context) {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return CupertinoAlertDialog(
          title: const Text('Title'),
          content: const Text('This will be a long sub title..'),
          actions: [
            CupertinoDialogAction(
              onPressed: () {
                Navigator.of(context).pop(); // Close the dialog
              },
              child: const Text('Cancel'),
            ),
            CupertinoDialogAction(
              onPressed: () {
                Navigator.of(context).pop(); // Close the dialog
              },
              child: const Text('Done', style: TextStyle(color: Colors.red)),
            ),
          ],
        );
      },
    );
  }

  /// Show bottom sheet
  _showBottomSheet(context) {
    return showModalBottomSheet(
        context: context,
        isScrollControlled: true,
        shape: const RoundedRectangleBorder(
            borderRadius: BorderRadius.vertical(
                top: Radius.circular(20.0), bottom: Radius.circular(0.0))),
        builder: (context) {
          return StatefulBuilder(builder: (context, state) {
            return Container(
              width: double.infinity,
              height: 300.0,
              decoration: const BoxDecoration(
                  borderRadius: BorderRadius.only(
                topRight: Radius.circular(20),
                topLeft: Radius.circular(20),
              )),
            );
          });
        }).whenComplete(() {});
  }
}
