import '../colors.dart';
import 'helpers/text_theme.dart';
import 'helpers/input_theme.dart';
import 'helpers/button_theme.dart';
import 'helpers/tab_bar_theme.dart';
import 'helpers/app_bar_theme.dart';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:google_fonts/google_fonts.dart';

/// App theme
ThemeData buildThemeData() {
  /// Base theme
  final baseTheme = ThemeData(
    textTheme: GoogleFonts.interTextTheme(),
  );

  return baseTheme.copyWith(
    /// Base
    canvasColor: primaryColor,
    scaffoldBackgroundColor: const Color(0XFFFDFDFD),
    primaryColor: primaryColor,
    brightness: Brightness.light,
    primaryColorLight: primaryColor,
    primaryColorDark: primaryColorDark,
    cupertinoOverrideTheme: const CupertinoThemeData(
      primaryColor: secondaryColor,
    ),

    /// App bar
    appBarTheme: appBarTheme,

    /// Text Field
    inputDecorationTheme: inputDecorationTheme,

    /// Text selection
    textSelectionTheme:
        const TextSelectionThemeData(cursorColor: secondaryColor),

    /// Elevated Button theme
    elevatedButtonTheme: elevatedButtonThemeData,

    /// Outline Button theme
    outlinedButtonTheme: outlineButtonThemeData,

    /// Text Button theme
    textButtonTheme: textButtonThemeData,

    /// Tab Bar theme
    tabBarTheme: tabBarTheme,

    /// Divider
    dividerTheme: DividerThemeData(color: borderColor.withOpacity(0.6)),

    /// Drawer theme
    drawerTheme: DrawerThemeData(
      backgroundColor: primaryColor,
      surfaceTintColor: primaryColor,
      shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(0)),
    ),

    /// Bottom sheet
    bottomSheetTheme: const BottomSheetThemeData(
      backgroundColor: primaryColor,
      surfaceTintColor: primaryColor,
      shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.only(
              topRight: Radius.circular(20.0), topLeft: Radius.circular(20.0))),
    ),

    /// Dialog
    dialogTheme: const DialogTheme(
      backgroundColor: primaryColor,
      surfaceTintColor: primaryColor,
      shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.only(
              topRight: Radius.circular(20.0), topLeft: Radius.circular(20.0))),
    ),

    /// Pop menu
    popupMenuTheme: const PopupMenuThemeData(
        color: primaryColor, surfaceTintColor: primaryColor),

    /// Text theme
    textTheme: textTheme,
    bottomAppBarTheme: const BottomAppBarTheme(color: primaryColor),
  );
}
