import '../../colors.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// Text Theme
final TextTheme textTheme = TextTheme(
  displayLarge: commonFont.copyWith(
      color: textColorDark, fontSize: 86.0, letterSpacing: -1.0),
  displayMedium: commonFont.copyWith(
    color: textColorDark,
    fontSize: 42.0,
    letterSpacing: 0.0,
    fontWeight: FontWeight.w800,
  ),
  displaySmall: commonFont.copyWith(
    color: textColorDark,
    fontSize: 34.0,
    letterSpacing: 0.0,
    height: 1.2,
    fontWeight: FontWeight.w800,
  ),
  headlineMedium: commonFont.copyWith(
      color: textColorDark,
      fontWeight: FontWeight.w700,
      fontSize: 34.0,
      letterSpacing: 0.25),
  headlineSmall: commonFont.copyWith(
      color: textColorDark,
      fontSize: 30.0,
      fontWeight: FontWeight.w700,
      letterSpacing: 1.0),
  titleLarge: commonFont.copyWith(
      color: textColorDark,
      fontSize: 24.0,
      fontWeight: FontWeight.w600,
      letterSpacing: -0.6),
  titleMedium: commonFont.copyWith(
    color: textColorDark,
    fontSize: 18.0,
    letterSpacing: 0.15,
  ),
  titleSmall: commonFont.copyWith(
      color: textColorDark, fontSize: 16.0, letterSpacing: 0.1),
  bodyLarge: commonFont.copyWith(
      color: textColorDark, fontSize: 15.0, letterSpacing: 0.0, height: 1.3),
  bodyMedium: commonFont.copyWith(
      color: textColorDark, fontSize: 13.0, letterSpacing: 0.25),
  bodySmall: commonFont.copyWith(
      color: secondaryColor, fontSize: 10.0, letterSpacing: 0.4),
  labelSmall: commonFont.copyWith(
      color: textColorDark, fontSize: 12.0, letterSpacing: 2.0),
);
