import '../../colors.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// Tab Bar theme
final TabBarTheme tabBarTheme = TabBarTheme(
    labelStyle: commonFont.copyWith(
        color: textColorDark,
        fontWeight: FontWeight.w600,
        fontSize: 15.0,
        letterSpacing: 0.15),
    unselectedLabelStyle: commonFont.copyWith(
        color: textColorLight,
        fontWeight: FontWeight.w400,
        fontSize: 15.0,
        letterSpacing: 0.15),
    indicator: UnderlineTabIndicator(
        borderSide: const BorderSide(
          color: secondaryColor,
          width: 4.0,
        ),
        borderRadius: BorderRadius.circular(4)));
