import '../../colors.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// Text Field Theme
final InputDecorationTheme inputDecorationTheme = InputDecorationTheme(
    labelStyle: commonFont.copyWith(
        color: textColorDark.withOpacity(0.5),
        fontSize: 15.0,
        letterSpacing: 0.15,
        height: 1.3),
    hintStyle: commonFont.copyWith(
        color: textColorDark.withOpacity(0.5),
        fontSize: 15.0,
        letterSpacing: 0.15,
        height: 1.3),
    floatingLabelStyle: commonFont.copyWith(color: textColorDark),
    contentPadding:
        const EdgeInsets.symmetric(vertical: 10.0, horizontal: 12.0),
    iconColor: textColorLight,
    errorBorder: const OutlineInputBorder(
        borderSide: BorderSide(color: errorColor),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    errorMaxLines: 1,
    suffixIconColor: textColorLight,
    border: const OutlineInputBorder(
        borderSide: BorderSide(color: borderColor),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    enabledBorder: const OutlineInputBorder(
        borderSide: BorderSide(color: borderColor),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    focusedBorder:
        const OutlineInputBorder(borderSide: BorderSide(color: borderColor)));
