import '../../colors.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// Outline Button theme
final OutlinedButtonThemeData outlineButtonThemeData = OutlinedButtonThemeData(
    style: ButtonStyle(
        textStyle: WidgetStateProperty.all(commonFont.copyWith(
            color: secondaryColor,
            fontWeight: FontWeight.w600,
            fontSize: 15.0,
            letterSpacing: 0.3)),
        foregroundColor: WidgetStateProperty.all(secondaryColor),
        side: WidgetStateProperty.all(const BorderSide(color: secondaryColor)),
        minimumSize: WidgetStateProperty.all(const Size(220.0, 50.0)),
        shape: WidgetStateProperty.all(
            RoundedRectangleBorder(borderRadius: BorderRadius.circular(10.0))),
        padding: WidgetStateProperty.all(
            const EdgeInsets.symmetric(vertical: 12.0, horizontal: 22.0))));

/// Elevated Button Theme
final ElevatedButtonThemeData elevatedButtonThemeData = ElevatedButtonThemeData(
    style: ButtonStyle(
        backgroundColor: WidgetStateProperty.all<Color>(secondaryColor),
        minimumSize: WidgetStateProperty.all(const Size(220.0, 50.0)),
        foregroundColor: WidgetStateProperty.all<Color>(primaryColor),
        textStyle: WidgetStateProperty.all(commonFont.copyWith(
            color: primaryColor,
            fontWeight: FontWeight.w600,
            fontSize: 15.0,
            letterSpacing: 0.3)),
        shape: WidgetStateProperty.all(
            RoundedRectangleBorder(borderRadius: BorderRadius.circular(10.0))),
        padding: WidgetStateProperty.all(
            const EdgeInsets.symmetric(vertical: 12.0, horizontal: 22.0))));

/// Text Button Theme
final TextButtonThemeData textButtonThemeData = TextButtonThemeData(
    style: ButtonStyle(
  textStyle: WidgetStateProperty.all(commonFont.copyWith(
      color: secondaryColor,
      fontWeight: FontWeight.w600,
      fontSize: 15.0,
      letterSpacing: 0.3)),
));
