import '../../colors.dart';
import 'package:flutter/services.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// App Bar theme
final AppBarTheme appBarTheme = AppBarTheme(
    systemOverlayStyle: const SystemUiOverlayStyle(
      statusBarColor: primaryColor,
      statusBarIconBrightness: Brightness.dark,
      statusBarBrightness: Brightness.light,
    ),
    color: primaryColor,
    foregroundColor: textColorDark,
    elevation: 0.0,
    iconTheme: const IconThemeData(
      color: textColorDark,
    ),
    centerTitle: true,
    toolbarTextStyle: commonFont.copyWith(
      color: textColorDark,
    ),
    titleTextStyle: commonFont.copyWith(
        color: textColorDark,
        fontSize: 16.0,
        fontWeight: FontWeight.w600,
        letterSpacing: 0));
