import '../../colors.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// Text Field Theme
final InputDecorationTheme inputDecorationTheme = InputDecorationTheme(
    labelStyle: const TextStyle(
        color: primaryColor,
        fontWeight: FontWeight.w400,
        fontSize: 15.0,
        letterSpacing: 0.0),
    hintStyle: commonFont.copyWith(
        color: primaryColor,
        fontWeight: FontWeight.w400,
        fontSize: 15.0,
        letterSpacing: 0.0),
    floatingLabelStyle: commonFont.copyWith(color: secondaryColor),
    contentPadding:
        const EdgeInsets.symmetric(vertical: 10.0, horizontal: 12.0),
    iconColor: primaryColor,
    errorBorder: const OutlineInputBorder(
        borderSide: BorderSide(color: errorColor),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    errorMaxLines: 1,
    suffixIconColor: primaryColor,
    border: const OutlineInputBorder(
        borderSide: BorderSide(color: primaryColor, width: 1.0),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    enabledBorder: const OutlineInputBorder(
        borderSide: BorderSide(color: primaryColor, width: 1.0),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    disabledBorder: const OutlineInputBorder(
        borderSide: BorderSide(color: primaryColor, width: 1.0),
        borderRadius: BorderRadius.all(Radius.circular(6.0))),
    focusedBorder: const OutlineInputBorder(
        borderSide: BorderSide(color: secondaryColor)));
