import '../../colors.dart';
import 'package:flutter/services.dart';
import 'package:flutter/material.dart';
import 'package:google_fonts/google_fonts.dart';

/// Font
final TextStyle commonFont = GoogleFonts.inter();

/// App Bar theme
final AppBarTheme appBarTheme = AppBarTheme(
    systemOverlayStyle: const SystemUiOverlayStyle(
      statusBarColor: darkPrimaryColor,
      statusBarIconBrightness: Brightness.light,
      statusBarBrightness: Brightness.dark,
    ),
    color: darkPrimaryColor,
    foregroundColor: primaryColor,
    elevation: 0.0,
    iconTheme: const IconThemeData(
      color: primaryColor,
    ),
    centerTitle: true,
    toolbarTextStyle: commonFont.copyWith(
      color: primaryColor,
    ),
    titleTextStyle: commonFont.copyWith(
        color: primaryColor,
        fontSize: 16.0,
        fontWeight: FontWeight.w600,
        letterSpacing: 0));
