import "dart:async";
import 'sq_user.dart';
import "dart:io" as io;
import "package:path/path.dart";
import 'package:sqflite/sqflite.dart';
import '../shared_pref/shared_pref.dart';
import '../shared_pref/value_store.dart';
import 'package:path_provider/path_provider.dart';

/// Sq-lite Class
class SqliteDB {
  static final SqliteDB _instance = SqliteDB.internal();

  factory SqliteDB() => _instance;
  static Database? _db;

  Future<Database?> get db async {
    if (_db != null) {
      return _db;
    }
    _db = await initDb();
    return _db;
  }

  SqliteDB.internal();

  /// Initialize database
  initDb() async {
    io.Directory documentDirectory = await getApplicationDocumentsDirectory();
    String path = join(documentDirectory.path, "database.db");
    var database = await openDatabase(path, version: 1, onCreate: _onCreate);
    return database;
  }

  /// Create all tables when database is created
  void _onCreate(Database db, int version) async {
    //createTables();
  }

  /// Create tables
  Future createTables() async {
    final tableCreated = await ValueStore().getTableCreatedTracker();
    if (tableCreated == 0) {
      await SqUser().createTable();
      await SharedPref().put("tableCreated", "int", 1);
    }
    return Future.value('success');
  }

  /// Count number of tables
  Future countTable() async {
    var dbClient = await db;
    var res =
        await dbClient!.rawQuery("""SELECT count(*) as count FROM sqlite_master
         WHERE type = 'table' 
         AND name != 'android_metadata' 
         AND name != 'sqlite_sequence';""");
    return res[0]['count'];
  }

  /// Drops a single table given the table name
  ///
  /// Argument [table] - table name (eg:- User)
  Future dropTable(table) async {
    var dbClient = await db;
    var res = await dbClient!.rawQuery("DROP TABLE $table");
    await dbClient.close();
    return res;
  }

  /// Drop all tables
  Future dropAll() async {
    var dbClient = await db;
    await dbClient!.transaction((txn) async {
      await txn.execute("DROP FROM User");
    });
  }

  /// Deletes data from table given the table name
  ///
  /// Argument [table] - table name (eg:-Pages)
  Future deleteTable(table) async {
    var dbClient = await db;
    var res = await dbClient!.rawQuery("DELETE FROM $table");
    return res;
  }

  /// Deletes data from all tables
  Future deleteAll() async {
    var dbClient = await db;
    await dbClient!.transaction((txn) async {
      await txn.execute("DELETE FROM User");
    });
  }
}
