import 'dart:async';
import 'sqlite.dart';
import '../data_objects/user.dart';
import 'package:sqflite/sqflite.dart';

class SqUser {
  /// Creates user Table
  Future createTable() async {
    final Database? dbClient = await SqliteDB().db;
    var res = await dbClient?.execute("""
      CREATE TABLE User(
        id TEXT PRIMARY KEY,
        email TEXT,
        name TEXT,
        image TEXT,
        level INTEGER,
        loginType TEXT,
        timestamp INTEGER,
        search TEXT
      )""");
    return res;
  }

  /// Adds data to user table
  Future putUser(user) async {
    final Database? dbClient = await SqliteDB().db;

    /// Cleans user table
    try {
      await SqliteDB().deleteTable("User");
    } catch (err) {
      err;
    }

    /// Adds user to table
    final User userObj = User.fromMap(user);
    final userJson = userObj.toMap();
    int res = await dbClient!.insert("User", userJson);
    return res;
  }

  /// Fetches User information
  Future fetchUserInfo() async {
    var dbClient = await SqliteDB().db;
    final res = await dbClient!.rawQuery("SELECT * FROM User");
    return res;
  }

  /// Deletes data from user table
  Future deleteUser() async {
    try {
      await SqliteDB().deleteTable("User");
    } catch (err) {
      err;
    }
  }

  /// Returns user id
  Future getUserId() async {
    var user = await SqUser().fetchUserInfo();
    String userId;
    if (user.length == 0) {
      userId = 'NA';
    } else {
      userId = user[0]['id'];
    }
    return userId;
  }

  /// Returns any key's value
  Future get(key) async {
    List<dynamic> user = await SqUser().fetchUserInfo();
    if (user.isEmpty) {
      return 'NA';
    } else {
      return user[0]['$key'];
    }
  }

  /// Update String
  Future updateString(key, val) async {
    final Database? dbClient = await SqliteDB().db;
    final res = await dbClient!.rawQuery("UPDATE User SET $key = '$val'");
    return res;
  }

  /// Update Integer
  Future updateInteger(key, val) async {
    final Database? dbClient = await SqliteDB().db;
    final res = await dbClient!.rawQuery("UPDATE User SET $key = $val");
    return res;
  }

  /// Increment
  Future increment(key, val) async {
    final Database? dbClient = await SqliteDB().db;
    final res = await dbClient!.rawQuery("UPDATE User SET $key = $key + $val");
    return res;
  }

  /// Update timestamp
  Future updateTs() async {
    int currentTs = DateTime.now().millisecondsSinceEpoch ~/ 1000;
    final Database? dbClient = await SqliteDB().db;
    final res =
        await dbClient!.rawQuery("UPDATE User SET timestamp = $currentTs");
    return res;
  }
}
