import 'shared_pref.dart';

class ValueStore {
  /// Get table created tracker
  Future<dynamic> getTableCreatedTracker() async {
    final tracker = await _getIntValue("tableCreated", 0);
    return tracker;
  }

  /// Check dark mode
  Future<dynamic> checkDarkMode() async {
    final check = await _getIntValue("darkMode", 0);
    return check;
  }


  /// Get value
  _getIntValue(key, defaultValue) async {
    int? val = await SharedPref().get("$key", "int");
    if (val == null) {
      val = 0;
      await SharedPref().put("$key", "int", 0);
    }
    return val;
  }

  /// Get value
  /*_getStringValue(key, defaultValue) async {
    String? val = await SharedPref().get("$key", "string");
    if (val == null) {
      val = "";
      await SharedPref().put("$key", "string", "");
    }
    return val;
  }*/
}
