import "dart:async";
import "package:shared_preferences/shared_preferences.dart";

class SharedPref {
  /// Initializes shared_preference
  void sharedPrefInit() async {
    try {
      /// Checks if shared preference exist
      Future<SharedPreferences> pref = SharedPreferences.getInstance();
      final SharedPreferences prefs = await pref;
      prefs.getString("check");
    } catch (err) {
      /// setMockInitialValues initiates shared preference
      /// Adds current_user as current user
      /// This is used later to check if shared_preference is initialized
      Future<SharedPreferences> pref = SharedPreferences.getInstance();
      final SharedPreferences prefs = await pref;
      prefs.setString("check", "check");
    }
  }

  /// General get request
  ///
  /// Arguments are field and type(eg:- "string")
  /// Returns the value of the field
  dynamic get(field, type) async {
    Future<SharedPreferences> pref = SharedPreferences.getInstance();
    final SharedPreferences prefs = await pref;
    if (type == "string") {
      String? res = prefs.getString("$field");
      return res;
    } else if (type == "int") {
      int? res = prefs.getInt("$field");
      return res;
    }
  }

  /// General put request
  ///
  /// Arguments field, type(eg:- "int") and value
  dynamic put(field, type, val) async {
    Future<SharedPreferences> pref = SharedPreferences.getInstance();
    final SharedPreferences prefs = await pref;
    if (type == "string") {
      var res = prefs.setString("$field", val);
      return res;
    } else if (type == "int") {
      var res = prefs.setInt("$field", val);
      return res;
    }
  }

  /// Increments any value on shared_preference by 1, given the key
  Future incrementer(key, int val) async {
    Future<SharedPreferences> pref = SharedPreferences.getInstance();
    final SharedPreferences prefs = await pref;
    final x = prefs.getInt("$key")!;
    final res = prefs.setInt(key, x + val);
    return res;
  }

  /// Decrements any value on shared_preference by 1
  ///
  /// Argument [key] - string
  Future decrementer(key) async {
    Future<SharedPreferences> pref = SharedPreferences.getInstance();
    final SharedPreferences prefs = await pref;
    final x = prefs.getInt("$key")!;
    if (x > 0) {
      final res = prefs.setInt(key, x - 1);
      return res;
    }
  }

  /// Reset all update trackers
  ///
  /// Used when user signs out of the app
  Future reset() async {
    Future<SharedPreferences> pref = SharedPreferences.getInstance();
    final SharedPreferences prefs = await pref;
    prefs.clear();
    await put('isInitialized', 'int', 1);
  }
}
