import 'helpers/settings_item.dart';
import 'helpers/logout_settings.dart';
import 'helpers/settings_header.dart';
import 'helpers/help_and_support.dart';
import '../../configure/app_info.dart';
import 'package:flutter/material.dart';
import 'package:ionicons/ionicons.dart';
import 'helpers/dark_mode_settings.dart';
import '../../utils/browser/browser.dart';
import 'helpers/delete_account_settings.dart';
import '../../utils/navigation/navigation.dart';
import '../profile/edit_profile/views/edit_profile.dart';


class DrawerSettings extends StatefulWidget {
  const DrawerSettings({super.key});

  @override
  State<DrawerSettings> createState() => _DrawerSettingsState();
}

class _DrawerSettingsState extends State<DrawerSettings>{
  /// Widget
  @override
  Widget build(BuildContext context) {
    return Drawer(
            child: ListView(
              children: <Widget>[
                /// Spacing
                const SizedBox(
                  height: 6,
                ),

                /// Drawer header
                const SettingsHeader(),

                /// Dark mode
                const DarkModeSettings(),

                /// Edit profile
                SettingsItem(
                    icon: Ionicons.person_circle_outline,
                    text: "Edit Profile",
                    actionFunc: () {
                      Navigator.pop(context);
                      BNavigator()
                          .historyRightNavigate(context, const EditProfile());
                    }),

                /// Help and Support
                const HelpAndSupport(),

                /// Privacy
                SettingsItem(
                    icon: Ionicons.lock_closed_outline,
                    text: 'Privacy Policy',
                    actionFunc: () {
                      BNavigator().historyRightNavigate(
                          context,
                          LinkBrowser(
                            url: AppInfo().privacy,
                            text: "Privacy Policy",
                          ));
                    }),

                /// Terms of service
                SettingsItem(
                    icon: Ionicons.document_outline,
                    text: 'Terms of Services',
                    actionFunc: () {
                      BNavigator().historyRightNavigate(
                          context,
                          LinkBrowser(
                            url: AppInfo().terms,
                            text: "Terms & Conditions",
                          ));
                    }),

                /// Delete Account
                const DeleteAccountSettings(),

                /// Log Out
                const LogoutSettings()
              ],
            ),
          );
  }
}
