import '../../../theme/colors.dart';
import 'package:flutter/material.dart';

class SettingsItem extends StatelessWidget {
  /// Variables
  final String text;
  final IconData icon;
  final Function actionFunc;

  const SettingsItem(
      {super.key,
      required this.text,
      required this.icon,
      required this.actionFunc});

  @override
  Widget build(BuildContext context) {
    return ListTile(
      title: Text(
        text,
        style: TextStyle(
            color: Theme.of(context).brightness == Brightness.dark
                ? primaryColor
                : textColorDark),
      ),
      leading: Icon(
        icon,
        color: Theme.of(context).brightness == Brightness.dark
            ? primaryColor
            : textColorDark,
      ),
      onTap: () {
        actionFunc();
      },
      trailing: const Icon(
        Icons.chevron_right,
        color: textColorLight,
      ),
    );
  }
}
