import '../../../theme/colors.dart';
import 'package:flutter/material.dart';
import '../../../datastore/sqlite/sq_user.dart';
import '../../../utils/navigation/navigation.dart';
import '../../../utils/avatars/simple_user_avatar.dart';
import '../../profile/edit_profile/views/edit_profile.dart';

class SettingsHeader extends StatefulWidget {
  const SettingsHeader({super.key});

  @override
  State<SettingsHeader> createState() => _SettingsHeaderState();
}

class _SettingsHeaderState extends State<SettingsHeader> {
  /// Variables
  dynamic _user = {};
  bool _loaded = false;

  /// Init
  @override
  void initState() {
    _getData();
    super.initState();
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return  ListTile(
            title: GestureDetector(
              onTap: () {
                Navigator.pop(context);
                BNavigator().historyRightNavigate(context, const EditProfile());
              },
              child: Text(
                !_loaded?"":"${_user['name']}",
                maxLines: 1,
                overflow: TextOverflow.ellipsis,
                style: TextStyle(
                    fontWeight: FontWeight.w800,
                    letterSpacing: 0.2,
                    color: Theme.of(context).brightness == Brightness.dark
                        ? primaryColor
                        : textColorDark),
              ),
            ),
            subtitle: Text(
              !_loaded?"":"${_user['email']}",
              maxLines: 1,
              overflow: TextOverflow.ellipsis,
              style: const TextStyle(color: textColorLight),
            ),
            leading: !_loaded?Container(width: 24,):GestureDetector(
                onTap: () {
                  Navigator.pop(context);
                  BNavigator()
                      .historyRightNavigate(context, const EditProfile());
                },
                child: SimpleUserAvatar(
                  image: "${_user['image']}",
                  size: 24,
                  actionFunc: () {},
                )),
          );
  }

  _getData() async {
    final List<dynamic> userInfo = await SqUser().fetchUserInfo();
    if (userInfo.isNotEmpty) {
      _user = userInfo[0];
      _loaded = true;
      _changeState();
    }
  }

  /// Refresh State
  _changeState() {
    if (mounted) {
      setState(() {});
    }
  }
}
