import 'settings_item.dart';
import 'package:flutter/material.dart';
import 'package:ionicons/ionicons.dart';
import '../../../utils/navigation/navigation.dart';
import '../../authentication/views/home/home.dart';
import '../../authentication/presenter/logout_presenter.dart';


class LogoutSettings extends StatefulWidget {
  const LogoutSettings({super.key});

  @override
  State<LogoutSettings> createState() => _LogoutSettingsState();
}

class _LogoutSettingsState extends State<LogoutSettings> implements LogoutContract{
  /// Initialize presenter
  LogoutPresenter? _presenter;

  /// Initialize
  _LogoutSettingsState() {
    _presenter = LogoutPresenter(this);
  }

  /// On user logout complete
  @override
  void onLogoutComplete(item) async {
    if (mounted) {
      if (item['status'] == 'success') {
        /// Redirect to auth home
        BNavigator().rightNavigate(context, const AuthHome());
      }
    }
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return SettingsItem(
        icon: Ionicons.log_out_outline,
        text: 'Log Out',
        actionFunc: () {
          _presenter!.logout();
        });
  }
}
