import 'settings_item.dart';
import 'package:flutter/material.dart';
import 'package:ionicons/ionicons.dart';
import '../../../configure/app_info.dart';
import 'package:url_launcher/url_launcher.dart';


class HelpAndSupport extends StatelessWidget {
  const HelpAndSupport({super.key});

  @override
  Widget build(BuildContext context) {
    return SettingsItem(
        icon: Ionicons.mail_outline,
        text: 'Help and Support',
        actionFunc: () {
          _openEmail();
        });
  }

  /// Open email
  _openEmail() async {
    final Uri emailLaunchUri = Uri(
      scheme: 'mailto',
      path: AppInfo().emailId,
      query: encodeQueryParameters(<String, String>{
        'subject': 'Hello Team Hunt Fitness.',
      }),
    );

    launchUrl(emailLaunchUri);
  }

  /// Encode url
  String? encodeQueryParameters(Map<String, String> params) {
    return params.entries
        .map((MapEntry<String, String> e) =>
    '${Uri.encodeComponent(e.key)}=${Uri.encodeComponent(e.value)}')
        .join('&');
  }
}
