import '../../../theme/colors.dart';
import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:ionicons/ionicons.dart';
import '../../../utils/alerts/snackbars.dart';
import '../../../utils/navigation/navigation.dart';
import '../../authentication/views/home/home.dart';
import 'package:connectivity_plus/connectivity_plus.dart';
import '../../../utils/loading/small_loading_indicator.dart';
import '../../authentication/presenter/delete_account_presenter.dart';

class DeleteAccountSettings extends StatefulWidget {
  const DeleteAccountSettings({super.key});

  @override
  State<DeleteAccountSettings> createState() => _DeleteAccountSettingsState();
}

class _DeleteAccountSettingsState extends State<DeleteAccountSettings>
    implements DeleteAccountContract {
  /// Variables
  bool _isDeletingAccount = false;

  /// Initialize presenter
  DeleteAccountPresenter? _presenter;

  /// Initialize
  _DeleteAccountSettingsState() {
    _presenter = DeleteAccountPresenter(this);
  }

  /// On user deleteAccount complete
  @override
  void onDeleteAccountComplete(item) async {
    if (mounted) {
      if (item['status'] == 'success') {
        /// Redirect to auth home
        BNavigator().rightNavigate(context, const AuthHome());
      }
    }
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return ListTile(
      title: Text(
        "Delete Account",
        style: TextStyle(
            color: Theme.of(context).brightness == Brightness.dark
                ? primaryColor
                : textColorDark),
      ),
      leading: Icon(
        Ionicons.trash_bin_outline,
        color: Theme.of(context).brightness == Brightness.dark
            ? primaryColor
            : textColorDark,
      ),
      onTap: () {
        _showDeleteAccountDialog(context);
      },
      trailing: _isDeletingAccount
          ? const SmallLoadingIndicator(color: errorColor)
          : const Icon(
              Icons.chevron_right,
              color: textColorLight,
            ),
    );
  }

  /// Show pop up
  void _showDeleteAccountDialog(BuildContext context) async {
    showDialog(
      context: context,
      builder: (BuildContext context) {
        return CupertinoAlertDialog(
          title: const Text('Delete Account'),
          content: const Text('Are you sure you want to delete your account?'),
          actions: [
            CupertinoDialogAction(
              onPressed: () {
                Navigator.of(context).pop(); // Close the dialog
              },
              child: Text(
                'Cancel',
                style: TextStyle(
                    color: Theme.of(context).brightness == Brightness.light
                        ? textColorDark
                        : primaryColor),
              ),
            ),
            CupertinoDialogAction(
              onPressed: () {
                _deleteAccount();
                Navigator.of(context).pop(); // Close the dialog
              },
              child: const Text('Delete', style: TextStyle(color: Colors.red)),
            ),
          ],
        );
      },
    );
  }

  /// Delete Account
  _deleteAccount() async {
    if (!_isDeletingAccount) {
      final bool isConnected = await _checkConnectivity();
      if (isConnected) {
        _isDeletingAccount = true;
        _changeState();
        _presenter!.deleteAccount();
      } else {
        if (mounted) {
          PSnackbars().showErrorSnackbar("No Network", context);
        }
      }
    }
  }

  /// Check connectivity
  _checkConnectivity() async {
    final List<ConnectivityResult> connectivityResult =
        await (Connectivity().checkConnectivity());
    if (connectivityResult.contains(ConnectivityResult.none)) {
      return false;
    } else {
      return true;
    }
  }

  /// Refresh State
  _changeState() {
    if (mounted) {
      setState(() {});
    }
  }
}
