import '../../../theme/colors.dart';
import 'package:flutter/material.dart';
import 'package:adaptive_theme/adaptive_theme.dart';
import '../../../datastore/shared_pref/shared_pref.dart';
import '../../../datastore/shared_pref/value_store.dart';


class DarkModeSettings extends StatefulWidget {
  const DarkModeSettings({super.key});

  @override
  State<DarkModeSettings> createState() => _DarkModeSettingsState();
}

class _DarkModeSettingsState extends State<DarkModeSettings> {
  /// Variables
  bool isDarkMode = false;

  /// Init
  @override
  void initState() {
    _checkDarkMode();
    super.initState();
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return ListTile(
      title: Text(
        "Dark Mode",
        style: TextStyle(
            color: Theme.of(context).brightness == Brightness.dark
                ? primaryColor
                : textColorDark),
      ),
      leading: Icon(
        Icons.nightlight_outlined,
        color: Theme.of(context).brightness == Brightness.dark
            ? primaryColor
            : textColorDark,
      ),
      onTap: () {},
      trailing: Switch(
          value: isDarkMode,
          activeColor: secondaryColor,
          inactiveTrackColor: primaryColor,
          onChanged: (val) {
            _changeDarkMode(val, context);
          }),
    );
  }


  /// Check dark mode
  _checkDarkMode() async {
    final darkMode = await ValueStore().checkDarkMode();
    isDarkMode = darkMode == 1;
    _changeState();
  }

  /// Change dark mode
  _changeDarkMode(val, context) async {
    isDarkMode = val;
    _changeState();
    await SharedPref().put("darkMode", "int", isDarkMode ? 1 : 0);
    if (isDarkMode) {
      AdaptiveTheme.of(context).setDark();
    } else {
      AdaptiveTheme.of(context).setLight();
    }
    _changeState();
  }

  /// Refresh State
  _changeState() {
    if (mounted) {
      setState(() {});
    }
  }
}
