import '../../theme/colors.dart';
import 'package:flutter/material.dart';

class Layout extends StatefulWidget {
  /// Variables
  final int activeIndex;

  /// Initialize
  const Layout({super.key, required this.activeIndex});

  @override
  State<Layout> createState() => _LayoutState();
}

class _LayoutState extends State<Layout> {
  /// Variables
  int _selectedIndex = 0;

  /// Init
  @override
  void initState() {
    _selectedIndex = widget.activeIndex;
    super.initState();
  }

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      bottomNavigationBar: BottomNavigationBar(
        type: BottomNavigationBarType.fixed,
        onTap: (index) {
          _selectedIndex = index;
          setState(() {});
        },
        showSelectedLabels: false,
        showUnselectedLabels: false,
        selectedFontSize: 12.0,
        unselectedFontSize: 12.0,
        selectedItemColor: secondaryColor,
        unselectedItemColor: Colors.grey,
        currentIndex: _selectedIndex,
        items: const <BottomNavigationBarItem>[
          BottomNavigationBarItem(
            icon: Icon(
              Icons.home_outlined,
            ),
            activeIcon: Icon(
              Icons.home,
            ),
            label: 'Home',
          ),
          BottomNavigationBarItem(
            icon: Icon(
              Icons.sports_gymnastics_outlined,
            ),
            activeIcon: Icon(
              Icons.sports_gymnastics,
            ),
            label: 'Forum',
          ),
          BottomNavigationBarItem(
            icon: Icon(
              Icons.breakfast_dining_outlined,
            ),
            activeIcon: Icon(
              Icons.breakfast_dining,
            ),
            label: "Credit Rating",
          ),
          BottomNavigationBarItem(
            icon: Icon(
              Icons.person_outline,
            ),
            activeIcon: Icon(
              Icons.person,
            ),
            label: 'CCC List',
          ),
        ],
      ),
      body: IndexedStack(
        index: _selectedIndex,
        children: const [
          Scaffold(),
          Scaffold(),
          Scaffold(),
          Scaffold(),
        ],
      ),
    );
  }
}
