import '../data_objects/user.dart';
import 'package:cloud_firestore/cloud_firestore.dart';

class FireStoreUserDB {
  /// Initialize Fire-store instance
  final db = FirebaseFirestore.instance;

  /// Adds user
  addUser(userInfo) async {
    await db.doc('users/${userInfo['id']}').set(userInfo);
    return {'status': 'success', 'user': userInfo};
  }

  /// Gets user data
  getUser(id) async {
    dynamic userData;
    final data = await db.doc('users/$id').get();
    if (data.exists) {
      userData = {"user": data.data(), "status": "success"};
    } else {
      userData = {"status": "failed", "user": {}};
    }
    return userData;
  }

  /// Search user
  searchUser(searchTerm) async {
    final users = await db
        .collection('users')
        .where('search', arrayContains: searchTerm)
        .limit(8)
        .get();

    List allUsers = [];
    for (var user in users.docs) {
      final User userObj = User.fromMap(user.data());
      allUsers.add(userObj.toMap());
    }

    return {"status": "success", "data": allUsers};
  }

  /// Update user data
  updateUser(id, key, value) async {
    await db.doc('users/$id').update({"$key": "$value"});
    return "success";
  }

  /// Update integer
  updateInteger(id, key, value) async {
    await db.doc('users/$id').update({"$key": value});
    return "success";
  }

  /// Update all the data
  updateAllData(id, data) async {
    await db.doc('users/$id').update(data);
    return "success";
  }

  /// Delete user
  deleteUser(user) async {
    String id = user["id"];
    await db.doc('users/$id').delete();
    await db.doc('deletedUsers/$id').set(user);
    return "success";
  }

  /// Check deleted
  checkDeleted(id) async {
    final data = await db.doc('deletedUsers/$id').get();
    if (data.exists) {
      return true;
    }
    return false;
  }
}
