import 'dart:typed_data';
import "../model/model.dart";
import '../model/api_calls/update_dp_api_calls.dart';

/// Contract class
abstract class UpdateDpContract {
  void onDpUpdated(item);
}

/// Presenter class
class UpdateDpPresenter {
  /// Defines view and repository
  final UpdateDpContract? _view;
  UpdateDpApis? _repository;

  /// Initialize presenter
  UpdateDpPresenter(this._view) {
    _repository = UpdateDpApiCalls();
  }

  /// Update Profile
  void updateDp(Uint8List imageList) {
    _repository!.updateDp(imageList).then((i) => _view!.onDpUpdated(i));
  }
}
