import "../model/model.dart";
import "../model/api_calls/edit_profile_api_calls.dart";

/// Contract class
abstract class EditProfileContract {
  void onUserUpdated(item);
}

/// Presenter class
class EditProfilePresenter {
  /// Defines view and repository
  final EditProfileContract? _view;
  EditProfileApis? _repository;

  /// Initialize presenter
  EditProfilePresenter(this._view) {
    _repository = EditProfileApiCalls();
  }

  /// Edit Profile
  void editProfile(name) {
    _repository!.editProfile(name).then((i) => _view!.onUserUpdated(i));
  }
}
