import "../model.dart";
import 'dart:typed_data';
import '../../../../../datastore/sqlite/sq_user.dart';
import 'package:firebase_storage/firebase_storage.dart';
import '../../../../../datastore/firestore/firestore_user.dart';


class UpdateDpApiCalls implements UpdateDpApis {
  @override
  Future updateDp(Uint8List imageList) async {
    /// Convert to user object
    final List<dynamic> userData = await SqUser().fetchUserInfo();
    final String userId = await SqUser().getUserId();
    if (userData.isEmpty) {
      return {"status": "failed"};
    }

    /// Upload image to Firebase
    final storage = FirebaseStorage.instance;
    var snapshot =
    await storage.ref().child('profile/$userId.jpg').putData(imageList);
    var downloadUrl = await snapshot.ref.getDownloadURL();

    /// Update firebase
    await FireStoreUserDB().updateUser(userId, "image", downloadUrl);
    await SqUser().updateString("image", downloadUrl);

    return {"status": "success", "image": downloadUrl};
  }
}
