import 'dart:convert';

/// App User Class
class User {
  String? id;
  int? level;
  String? email;
  String? name;
  String? image;
  int? timestamp;
  String? loginType;
  List<String>? search;

  /// Initialize user class
  User();

  /// Maps User object to JSON
  /// and converts list to
  /// string for adding into
  /// sqlite
  Map<String, dynamic> toMap() {
    var map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['level'] = level;
    map['email'] = email;
    map['image'] = image;
    map['loginType'] = loginType;
    map['timestamp'] = timestamp;
    map['search'] = jsonEncode(search);
    return map;
  }

  /// Maps User object to JSON
  Map<String, dynamic> toObjectMap() {
    var map = <String, dynamic>{};
    map['id'] = id;
    map['name'] = name;
    map['level'] = level;
    map['email'] = email;
    map['image'] = image;
    map['loginType'] = loginType;
    map['timestamp'] = timestamp;
    map['search'] = search;
    return map;
  }

  /// Maps User JSON to User object
  static fromMap(Map map) {
    User user = User();
    user.id = map['id'];
    user.name = map['name'] ?? "";
    user.level = map["level"]??0;
    user.email = map['email'] ?? "";
    user.image = map["image"] ?? "";
    user.loginType = map["loginType"];
    user.timestamp = map['timestamp'];
    user.search = map["search"] == null
        ? []
        : map['search'] is String
            ? (jsonDecode(map['search']) as List<dynamic>).cast<String>()
            : map['search'].cast<String>();

    return user;
  }
}
