import 'package:flutter/material.dart';
import '../../../../../theme/colors.dart';

class TextDivider extends StatelessWidget {
  /// Variables
  final String text;

  /// Initialize
  const TextDivider({super.key, required this.text});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(vertical: 22.0),
      width: double.infinity,
      child: Row(
        children: [
          /// Line
          const Expanded(child: Divider()),

          /// Text
          Container(
            padding: const EdgeInsets.symmetric(horizontal: 12.0),
            child: Text(
              text,
              style: Theme.of(context)
                  .textTheme
                  .bodyMedium!
                  .copyWith(color: textColorLight),
            ),
          ),

          /// Line
          const Expanded(child: Divider()),
        ],
      ),
    );
  }
}
