import '../../sign_up/sign_up.dart';
import 'package:flutter/material.dart';
import '../../../../../utils/buttons/link_button.dart';

class SignUpText extends StatelessWidget {
  /// Variables
  final Color textColor;
  final Color linkColor;

  /// Initialize
  const SignUpText({super.key, required this.textColor, required this.linkColor});

  /// Widget
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 20.0, vertical: 8.0),
      width: double.infinity,
      alignment: Alignment.center,
      child: RichText(
          textAlign: TextAlign.center,
          text: TextSpan(
              style: Theme.of(context).textTheme.bodyMedium?.copyWith(
                  height: 1.5, fontWeight: FontWeight.w600,),
              children: [
                /// Intro text
                const TextSpan(
                    style: TextStyle(
                        fontWeight: FontWeight.w500,
                        letterSpacing: 0.0),
                    text: "Don't have an account? "),

                /// Terms of services link
                LinkButtonWithAnimation(
                    style: TextStyle(
                      shadows: [
                        Shadow(color: linkColor, offset: const Offset(0, -3))
                      ],
                      height: 2,
                      letterSpacing: 0.0,
                      color: Colors.transparent,
                      decoration: TextDecoration.underline,
                      decorationColor: linkColor,
                      decorationThickness: 1,
                    ),
                    page: const SignUp(),
                    text: "Register Here",
                    context: context),
              ])),
    );
  }
}
